% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{createGradient}
\alias{createGradient}
\alias{createGradient,Arena-method}
\title{Change substance concentration patterns in the environment according to a gradient}
\usage{
createGradient(
  object,
  mediac,
  position,
  smax,
  steep,
  add = FALSE,
  unit = "mmol/cell"
)

\S4method{createGradient}{Arena}(
  object,
  mediac,
  position,
  smax,
  steep,
  add = FALSE,
  unit = "mmol/cell"
)
}
\arguments{
\item{object}{An object of class Arena.}

\item{mediac}{A character vector giving the names of substances, which should be added to the environment (the default takes all possible substances).}

\item{position}{A character vector giving the position (top, bottom, right and left) of the gradient.}

\item{smax}{A number giving the maximum concentration of the substance.}

\item{steep}{A number between 0 and 1 giving the steepness of the gradient (concentration relative to the arena size).}

\item{add}{A boolean variable defining whether the amount of substance should be summed or replaced}

\item{unit}{A character used as chemical unit to set the amount of the substances to be added (valid values are: mmol/cell, mmol/cm2, mmol/arena, mM)}
}
\description{
The generic function \code{createGradient} changes specific substance concentration patterns in the environment.
}
\details{
This function can be used to add gradients of specific substances in the environment.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,30) #add all substances with no concentrations.
arena <- createGradient(arena,smax=50,mediac=c("EX_glc(e)","EX_o2(e)","EX_pi(e)"),
             position='top',steep=0.5, add=FALSE)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{changeSub}}
}
