% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc.PlotFrequencyInCalibration}
\alias{mcmc.PlotFrequencyInCalibration}
\title{Frequency in Calibration Period for Pareto/GGG, Pareto/NBD (HB) and Pareto/NBD (Abe)}
\usage{
mcmc.PlotFrequencyInCalibration(
  draws,
  cal.cbs,
  censor = 7,
  xlab = "Calibration period transactions",
  ylab = "Customers",
  title = "Frequency of Repeat Transactions",
  sample_size = 1000
)
}
\arguments{
\item{draws}{MCMC draws as returned by \code{*.mcmc.DrawParameters}}

\item{cal.cbs}{Calibration period customer-by-sufficient-statistic (CBS)
data.frame. It must contain columns for frequency ('x') and total time
observed ('T.cal').}

\item{censor}{Cutoff point for number of transactions in plot.}

\item{xlab}{Descriptive label for the x axis.}

\item{ylab}{Descriptive label for the y axis.}

\item{title}{Title placed on the top-center of the plot.}

\item{sample_size}{Sample size for estimating the probability distribution.
See \code{\link{mcmc.pmf}}.}
}
\value{
Calibration period repeat transaction frequency comparison matrix
  (actual vs. expected).
}
\description{
Plots a histogram and returns a matrix comparing the actual and expected
number of customers who made a certain number of repeat transactions in the
calibration period, binned according to calibration period frequencies.
}
\details{
The method \code{\link{mcmc.pmf}} is called to calculate the expected numbers
based on the corresponding model.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 100, burnin = 50, thin = 10, chains = 1) # short MCMC to run demo fast
mcmc.PlotFrequencyInCalibration(param.draws, cbs, sample_size = 100)
}
}
\seealso{
\code{\link{mcmc.pmf}}
}
