% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-nbd-mcmc.R
\name{pnbd.mcmc.DrawParameters}
\alias{pnbd.mcmc.DrawParameters}
\title{Pareto/NBD (HB) Parameter Draws}
\usage{
pnbd.mcmc.DrawParameters(cal.cbs, mcmc = 2500, burnin = 500, thin = 50,
  chains = 2, mc.cores = NULL, use_data_augmentation = TRUE,
  param_init = NULL, trace = 100)
}
\arguments{
\item{cal.cbs}{Calibration period customer-by-sufficient-statistic (CBS)
data.frame. It must contain a row for each customer, and columns \code{x}
for frequency, \code{t.x} for recency and \code{T.cal} for the total time
observed. A correct format can be easily generated based on the complete
event log of a customer cohort with \code{\link{elog2cbs}}.}

\item{mcmc}{Number of MCMC steps.}

\item{burnin}{Number of initial MCMC steps which are discarded.}

\item{thin}{Only every \code{thin}-th MCMC step will be returned.}

\item{chains}{Number of MCMC chains to be run.}

\item{mc.cores}{Number of cores to use in parallel (Unix only). Defaults to \code{min(chains, detectCores())}.}

\item{use_data_augmentation}{determines MCMC method to be used}

\item{param_init}{List of start values for cohort-level parameters.}

\item{trace}{Print logging statement every \code{trace}-th iteration. Not available for \code{mc.cores > 1}.}
}
\value{
2-element list:
\itemize{
 \item{\code{level_1 }}{list of \code{\link{mcmc.list}}s, one for each customer, with draws for customer-level parameters \code{lambda}, \code{tau}, \code{z}, \code{mu}}
 \item{\code{level_2 }}{\code{\link{mcmc.list}}, with draws for cohort-level parameters \code{r}, \code{alpha}, \code{s}, \code{beta}}
}
}
\description{
Returns draws from the posterior distributions of the Pareto/NBD (HB)
parameters, on cohort as well as on customer level.
}
\details{
See \code{demo('pareto-ggg')} for how to apply this model.

method 1) If \code{use_data_augmentation==TRUE} MCMC scheme takes advantage of
conjugate priors for drawing lambda and mu, by augmenting the parameter space
with unobserved lifetime 'tau' and activity status 'z'. See technical appendix
to (Abe 2009).

method 2) If \code{use_data_augmentation==FALSE} then implementation follows
Shao-Hui Ma & Jin-Lan Liu paper
\url{http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=4344404}, i.e. no data
augmentation and draws on individual level need to be done via slice
sampling. As such it is 10x slower than method 1)
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
param.draws <- pnbd.mcmc.DrawParameters(cbs,
  mcmc = 200, burnin = 100, thin = 20, chains = 1) # short MCMC to run demo fast

# cohort-level parameter draws
as.matrix(param.draws$level_2)
# customer-level parameter draws for customer with ID '4'
as.matrix(param.draws$level_1[["4"]])

# estimate future transactions
xstar.draws <- mcmc.DrawFutureTransactions(cbs, param.draws, cbs$T.star)
xstar.est <- apply(xstar.draws, 2, mean)
head(xstar.est)
}
\references{
Ma, Shao-Hui, and Jin-Lan Liu. 'The MCMC approach for solving the Pareto/NBD model and possible extensions.' Natural Computation, 2007. ICNC 2007. Third International Conference on. Vol. 2. IEEE, 2007. \url{http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=4344404}

Abe, Makoto. 'Counting your customers one by one: A hierarchical Bayes extension to the Pareto/NBD model.' Marketing Science 28.3 (2009): 541-553.
}
\seealso{
\code{\link{pnbd.GenerateData} } \code{\link{mcmc.DrawFutureTransactions} } \code{\link{mcmc.PAlive} }
}

