% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.ExpectedCumulativeTransactions}
\alias{bgnbd.ExpectedCumulativeTransactions}
\title{BG/NBD Expected Cumulative Transactions}
\usage{
bgnbd.ExpectedCumulativeTransactions(
  params,
  T.cal,
  T.tot,
  n.periods.final,
  hardie
)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{T.cal}{a vector to represent customers' calibration period lengths
(in other words, the "T.cal" column from a customer-by-sufficient-statistic
matrix).}

\item{T.tot}{end of holdout period. Must be a single value, not a vector.}

\item{n.periods.final}{number of time periods in the calibration and
holdout periods. See details.}

\item{hardie}{if TRUE, use h2f1 instead of hypergeo.}
}
\value{
Vector of expected cumulative total repeat transactions by all
customers.
}
\description{
Calculates the expected cumulative total repeat transactions by all customers
for the calibration and holdout periods.
}
\details{
The function automatically divides the total period up into n.periods.final
time intervals. n.periods.final does not have to be in the same unit of time
as the T.cal data. For example: - if your T.cal data is in weeks, and you
want cumulative transactions per week, n.periods.final would equal T.star. -
if your T.cal data is in weeks, and you want cumulative transactions per day,
n.periods.final would equal T.star * 7.

The holdout period should immediately follow the calibration period. This
function assume that all customers' calibration periods end on the same date,
rather than starting on the same date (thus customers' birth periods are
determined using max(T.cal) - T.cal rather than assuming that it is 0).
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

params <- c(0.243, 4.414, 0.793, 2.426)

# Returns a vector containing cumulative repeat transactions for 273 days.
# All parameters are in weeks; the calibration period lasted 39 weeks.
bgnbd.ExpectedCumulativeTransactions(params,
                                     T.cal = cal.cbs[,"T.cal"],
                                     T.tot = 39,
                                     n.periods.final = 273,
                                     hardie = TRUE)
}
\seealso{
\code{\link{bgnbd.Expectation}}
}
