% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianRankCorr.R
\name{gaussianRankCorr}
\alias{gaussianRankCorr}
\title{Gaussian rank correlation}
\usage{
gaussianRankCorr(x, vec = FALSE)
}
\arguments{
\item{x}{A numeric matrix representing data where the number of rows is the number of 
independent data points and the number of columns are the number of variables in the dataset.}

\item{vec}{A logical argument indicating if the vector of correlations should be returned 
instead of a matrix.}
}
\value{
Gaussian rank correlation matrix (default) or a vector of pair correlations.
}
\description{
This function computes the Gaussian rank correlation of Boudt et al. (2012).
}
\examples{
data(ma2)
set.seed(100)

# generate 1000 simualtions from the ma2 simulation function
x <- t(replicate(1000, ma2_sim(ma2$start, 10)))

corr1 <- cor(x) # traditional correlation matrix
corr2 <- gaussianRankCorr(x) # Gaussian rank correlation matrix
par(mfrow = c(1, 2))
image(corr1, main = 'traditional correlation matrix')
image(corr2, main = 'Gaussian rank correlation matrix')

std <- apply(x, MARGIN = 2, FUN = sd) # standard deviations
cor2cov(gaussianRankCorr(x), std) # convert to covariance matrix

}
\references{
Boudt, K., Cornelissen, J., and Croux, C. (2012). The Gaussian rank correlation estimator: 
robustness properties. Statistics and Computing, 22(2):471-483.
}
\seealso{
\code{\link{cor2cov}} for converting a correlation matrix to a covariance matrix.
}
