% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Kinder}
\alias{Kinder}
\title{Reading scores for first grade children who attended kindergarten versus
those who did not}
\format{
A data frame/tibble with eight observations on three variables
\describe{ 
\item{pair}{a numeric indicator of pair} 
\item{kinder}{reading score of kids who went to kindergarten} 
\item{nokinder}{reading score of kids who did not go to kindergarten} 
}
}
\usage{
Kinder
}
\description{
Data for Exercise 7.68
}
\examples{

boxplot(Kinder$kinder, Kinder$nokinder)
diff <- Kinder$kinder - Kinder$nokinder
qqnorm(diff)
qqline(diff)
shapiro.test(diff)
t.test(Kinder$kinder, Kinder$nokinder, paired = TRUE)
# Or
t.test(diff)
rm(diff)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
