% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Insulate}
\alias{Insulate}
\title{Heat loss through a new insulating medium}
\format{
A data frame/tibble with ten observations on two variables
\describe{ 
\item{temp}{outside temperature (in degrees Celcius)} 
\item{loss}{heat loss (in BTUs)} 
}
}
\usage{
Insulate
}
\description{
Data for Exercise 9.50
}
\examples{

plot(loss ~ temp, data = Insulate)
model <- lm(loss ~ temp, data = Insulate)
abline(model, col = "blue") 
summary(model)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Insulate, aes(x = temp, y = loss)) + 
           geom_point() + 
           geom_smooth(method = "lm", se = FALSE) + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
