% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Tenness}
\alias{Tenness}
\title{Tennessee self concept scores for 20 gifted high school students}
\format{A data frame/tibble with 20 observations on one variable
\describe{ 
\item{score}{Tennessee Self-Concept Scale score} 
}}
\usage{
Tenness
}
\description{
Data for Exercise 6.56
}
\examples{

hist(Tenness$score, freq= FALSE, main = "", col = "green",
xlab = "Tennessee Self-Concept Scale score")
lines(density(Tenness$score))
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Tenness, aes(x = score, y = ..density..)) + 
           geom_histogram(binwidth = 2, fill = "purple", color = "black") +
           geom_density(color = "red", fill = "pink", alpha = 0.3) + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
