\name{Challeng}
\alias{Challeng}
\docType{data}
\title{Temperatures and O-ring failures for the launches of the space shuttle Challenger}
\description{
  Data for Examples 1.11, 1.12, 1.13, 2.11 and 5.1 
}
\usage{Challeng}
\format{
  A data frame with 25 observations on the following 4 variables.
  \describe{
    \item{\code{flight}}{a factor with levels \code{1} \code{2} \code{3} \code{4} \code{41-b} \code{41-c} \code{41-d} \code{41-g} \code{5} \code{51-a} \code{51-b} \code{51-c} \code{51-d} \code{51-f} \code{51-g} \code{51-i} \code{51-j} \code{6} \code{61-a} \code{61-b} \code{61-c} \code{61-i} \code{7} \code{8} \code{9}}
    \item{\code{date}}{a factor with levels \code{1/12/86} \code{1/24/85} \code{1/28/86} \code{10/3/85} \code{10/30/85} \code{10/5/84} \code{11/11/82} \code{11/12/81} \code{11/26/85} \code{11/28/83} \code{11/8/84} \code{2/3/84} \code{3/22/82} \code{4/12/81} \code{4/12/85} \code{4/29/85} \code{4/4/83} \code{4/6/84} \code{6/17/85} \code{6/18/83} \code{6/27/82} \code{7/29/85} \code{8/27/85} \code{8/30/83} \code{8/30/84}}
    \item{\code{temp}}{a numeric vector}
    \item{\code{Failures}}{a numeric vector}
  }
}
\source{Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}. Duxbury}

\examples{
str(Challeng)
attach(Challeng)
stem(temp)
summary(temp)
IQR(temp)
quantile(temp)
fivenum(temp)
stem(sort(temp)[-1])
summary(sort(temp)[-1])
IQR(sort(temp)[-1])
quantile(sort(temp)[-1])
fivenum(sort(temp)[-1])
par(mfrow=c(1,2))
qqnorm(temp)
qqline(temp)
qqnorm(sort(temp)[-1])
qqline(sort(temp)[-1])
par(mfrow=c(1,1))
detach(Challeng)
}
\keyword{datasets}
