% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_contests.R
\name{simulate_comparisons}
\alias{simulate_comparisons}
\title{Simulate contests from the Bradley--Terry Model}
\usage{
simulate_comparisons(n.contests, true.quality, sigma.obs)
}
\arguments{
\item{n.contests}{The number of contests to be carried out}

\item{true.quality}{A vector with the level of deprivation in each area on the log scale.}

\item{sigma.obs}{Standard deviation for the noise to be added to the level of deprivation in each area. If 0, no noise is used.}
}
\value{
A list containing a data.frame with each pair-wise contest, the outcome (a 1 for a win, a 0 for a loss),
and a win matrix where the i,j^th element is the number of times i beat j
}
\description{
This function simulates pair-wise contests according to the Bradley--Terry model. It require the true quality of the areas and the number of comparisons to be carried out. It can also include some judge noise or error.
When including noise, each time a judge carries out a comparisons, we assume they use the true quality with some zero-mean normal noise added. The standard deviation must be specified.
}
\examples{

example.deprivation <- -2:2 #True level of deprivation in each area
example.comparisons <- simulate_comparisons(10, example.deprivation, 0)
#generate comparisons with judge noise.
example.comparisons <- simulate_comparisons(10, example.deprivation, 0.1)
}
