% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{run_mcmc_with_ordering}
\alias{run_mcmc_with_ordering}
\title{Run the BSBT MCMC algorithm with ordering constraints}
\usage{
run_mcmc_with_ordering(
  n.iter,
  delta,
  covariance.matrix,
  win.matrix,
  f.initial,
  S,
  alpha = FALSE,
  omega = 0.1,
  chi = 0.1
)
}
\arguments{
\item{n.iter}{The number of iterations to be run}

\item{delta}{The underrlaxed tuning parameter must be in (0, 1)}

\item{covariance.matrix}{The output from the covariance matrix function, which contains the decomposed and inverted covariance matrix.}

\item{win.matrix}{A matrix, where w_ij give the number of times area i beat j}

\item{f.initial}{A vector of the initial estimate for f}

\item{S}{A list of ordering constraints. There are four elements in each set, the label of the two areas, the value of the constraints, and the confidence parameter; S = (i, j, ±1, nu).}

\item{alpha}{A boolean if inference for alpha should be carried out. If this is TRUE, the covariance matrix}

\item{omega}{The value of the inverse gamma shape parameter}

\item{chi}{The value of the inverse gamma scale parameter}
}
\value{
A list of MCMC output
\itemize{
\item f.matrix - A matrix containing the each iteration of f
\item alpha.sq - A vector containing the iterations of alpha^2
\item acceptance.rate - The acceptance rate for f
\item time.taken - Time taken to run the MCMC algorithm in seconds
}
}
\description{
This function runs the BSBT MCMC algorithm with ordering constraints. This allows the sign of lambda_i - lambda_j to be specified. The confidence parameters specify the confidence in this constraint. As this parameter approaches 0, all proposals that do not meet this constraint will be rejected. As this parameter approaches infinity, all proposals are accepted, regardless of the constraint. Only small numbers of ordering constraints should be included, as they can affect the mixing of the markov chain.
}
\examples{

n.iter <- 10
delta <- 0.1
covariance.matrix <- list()
covariance.matrix$mean <- c(0, 0, 0)
covariance.matrix$decomp <- diag(3)
covariance.matrix$inv    <- diag(3)
comparisons <- data.frame("winner" = c(1, 3, 2, 2), "loser" = c(3, 1, 1, 3))
win.matrix <- comparisons_to_matrix(3, comparisons)
f.initial <- c(0, 0, 0)
S <- list()
S[[1]] <- c(1, 3, -1, 3) #Specify that lambda_1 - lambda_3 < 0,
#and the confidence parameter has value 3.
S[[2]] <- c(1, 2, -1, 3) #Specify that lambda_1 - lambda_2 < 0,
#and the confidence parameter has value 3.
mcmc.output <- run_mcmc_with_ordering(n.iter, delta, covariance.matrix, win.matrix, f.initial, S)


}
