% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-stationarity-test.R
\name{stationarity_test}
\alias{stationarity_test}
\title{Stationarity test with univariate data}
\usage{
stationarity_test(x, type.test)
}
\arguments{
\item{x}{a numeric vector or time series.}

\item{type.test}{character such as "Box-Pierce and Ljung-Box","Kwiatkowski-Phillips-Schmidt-Shin (KPSS)", "Augmented Dickey-Fuller Test (ADF)", "Phillips-Perron Unit Root Test"}
}
\value{
a number that indicates the P-value of the stationarity test
}
\description{
Performs different types of stationarity test.
}
\examples{

library(tseries)

# one and a half week stock index
# data including a weekend
y <-ts(c(5353.08,5409.24,5315.57,5270.53, 5211.66,NA,NA,5160.80,5172.37,5160.80,5172.37))

stationarity_test(y, "Box-Pierce and Ljung-Box")


}
\seealso{
\code{normality_test}

Other Test: 
\code{\link{normality_test}()}

Other BRVM: 
\code{\link{BRVM.index}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_company_url}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{BRVM_traded_val}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()},
\code{\link{normality_test}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{BRVM}
\concept{Test}
