% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-boc.R
\name{BRVM_stock_market}
\alias{BRVM_stock_market}
\title{BRVM Official Quotation reviews}
\usage{
BRVM_stock_market(.weekday)
}
\arguments{
\item{.weekday}{A quoted date, ie. "2022-01-31" or "2022/01/31". The date must
be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD". Must not be a weekend or a holiday}
}
\value{
A formatabble table
}
\description{
This function receives as input a day of the week (working day) and returns the official quotation revews of that day.
}
\examples{
\donttest{
library(httr)
library(lubridate)
library(rvest)
library(timeDate)
library(formattable)
library(stringr)

BRVM_stock_market("2022-04-25")
BRVM_stock_market("2021-03-25")
}
}
\seealso{
Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}

Other BRVM: 
\code{\link{BRVM.index}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_company_url}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{BRVM_traded_val}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()},
\code{\link{normality_test}()},
\code{\link{stationarity_test}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{BRVM}
\concept{Data Retrieval}
