% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_b_call}
\alias{build_b_call}
\title{Create an API call for B-data flows}
\usage{
build_b_call(data_item, api_key, settlement_date = NULL, period = NULL,
  year = NULL, month = NULL, week = NULL, process_type = NULL,
  start_time = NULL, end_time = NULL, start_date = NULL,
  end_date = NULL, service_type = "csv", api_version = "v1")
}
\arguments{
\item{data_item}{character string; the id of the B flow}

\item{api_key}{character string; api key retrieved from the Elexon portal}

\item{settlement_date}{character string; settlement date (automatically cleaned by format_date)}

\item{period}{character string; settlement period}

\item{year}{character string; year}

\item{month}{character string; month}

\item{week}{character string; week}

\item{process_type}{character string; process type}

\item{start_time}{character string; start time}

\item{end_time}{character string; end time}

\item{start_date}{character string; start date}

\item{end_date}{character string; end date}

\item{service_type}{character string; file format (csv or xml)}

\item{api_version}{character string; version of the api to use (currently on v1)}
}
\value{
list; created url for the call, service type and data item
}
\description{
Create an API call for B-data flows
}
\examples{
build_b_call(data_item = "B1730", api_key = "12345", settlement_date = "14-12-2016")
build_b_call(data_item = "B1510", api_key = "12345", start_date = "01 Jan 2019",
start_time = "00:00:00", end_date = "02 Jan 2019", end_time = "24:00:00", service_type = "csv")
}
\seealso{
Other call-building functions: \code{\link{build_call}},
  \code{\link{build_legacy_call}},
  \code{\link{build_remit_call}}
}
\concept{call-building functions}
