% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_tp_diagnostic_plots}
\alias{get_tp_diagnostic_plots}
\title{Transition Probabilities: MCMC Diagnostic Plots}
\usage{
get_tp_diagnostic_plots(
  results,
  from = 1:results$Num_States,
  to = 1:results$Num_States,
  cov_levels = NULL,
  cov_labels = NULL,
  state_labels = 1:results$Num_States
)
}
\arguments{
\item{results}{results of transition probabilities, i.e., results$results_trans}

\item{from}{list of "from" states in target state transitions; default is all states}

\item{to}{list of "to" states in target state transitions; default is all states}

\item{cov_levels}{a matrix such that each row is a combination of covariate levels; default is all possible combinations of covariates}

\item{cov_labels}{a matrix such that row i represents the labels for covariate i; default labels for covariate i is 1:i}

\item{state_labels}{a vector of strings that represent the state labels; default is 1:Num_States}
}
\value{
No return value, called for plotting MCMC diagnostic plots for transition probabilities.
}
\description{
Provides the traceplots and autocorrelation plots for each transition type under combinations of covariate levels
}
\examples{

# Examples using the shortened built-in simulated Foxp2 data set, foxp2_sm
# recall the covariate labels are: ("HET","WT") and ("U","L","A")
# recall the state labels are 'd', 'm', 's', 'u'

results <- BMRMM(foxp2_sm,num_cov=2,duration_type='None',simsize=50)

# results for all transition types for every combinations of covariates
get_tp_diagnostic_plots(results$results_trans)

# results for all transition types for covariate levels (HET,U) and (WT,A)
get_tp_diagnostic_plots(results$results_trans,cov_levels=matrix(c(1,1,2,3),nrow=2,byrow=TRUE))

# results for all transition from (d,m) to (d,s) for covariate levels (HET,U) and (WT,A)
get_tp_diagnostic_plots(results$results_trans,from=c(1),to=c(2,3),
                        cov_levels=matrix(c(1,1,2,3),nrow=2,byrow=TRUE))

}
