% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeBirds.R
\name{organizeDate}
\alias{organizeDate}
\title{Organize the date-column(s)}
\usage{
organizeDate(x, columns)
}
\arguments{
\item{x}{A dataframe with at least the columns specified in 'columns'}

\item{columns}{A character vector with the column names for the dates specified.
It can either be one column formatted as "yyyy-mm-dd" or a vector of
length=3. If the column names are "year", "month" and "day" it will take
these column names. Otherwise, it will take the column names and interpret
the first as year, the second as month and the third as day.}
}
\value{
A data.frame with the columns "year", "month", "day"
}
\description{
Organize the date-column(s) in a dataframe to three columns
}
\examples{
ymd<-as.Date(Sys.Date())+1:5
organizeDate(as.data.frame(ymd), "ymd")
}
\keyword{internal}
