% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutPlot.R
\name{cutPlot}
\alias{cutPlot}
\title{Divides one or more plots into subplots}
\usage{
cutPlot(projCoord, plot, cornerNum, gridsize = 100, dimX = 200, dimY = 200)
}
\arguments{
\item{projCoord}{A data frame containing the projected coordinates of plot corners, with X and Y on the first and second column respectively}

\item{plot}{A vector indicating the plot codes}

\item{cornerNum}{A vector with corners numbered from 1 to 4 for each plot, numbering must be in clockwise direction}

\item{gridsize}{The size of the subplots}

\item{dimX}{A vector indicating the size of the plot on the X axis, in meters and in the relative coordinates system (if a single value is supplied, it will be replicated for all plots)}

\item{dimY}{A vector indicating the size of the plot on the Y axis, in meters and in the relative coordinates system (if a single value is supplied, it will be replicated for all plots)}
}
\value{
Returns a data-frame containing as many rows as there are corners corresponding to the subplots, and the following columns :
\itemize{
\item \code{plot}: The plot code
\item \code{subplot}: The automatically generated subplot code
\item \code{XRel}:  The relative coordinates on the X axis (defined by corners 1->4)
\item \code{YRel}:  The relative coordinates on the Y axis (defined by corners 1->2)
\item \code{XAbs}:  The absolute (projected) X coordinates
\item \code{YAbs}:  The absolute (projected) Y coordinates
}
}
\description{
This function divides a plot (or several plots) in subplots and returns the coordinates of the grid.
These coordinates are calculated by a bilinear interpolation with the projected corner coordinates as references.
}
\examples{

coord <- data.frame(X = c(0, 200, 0, 200), Y = c(0, 0, 200, 200)) + 5000
cornerNum <- c(1, 2, 4, 3)
plot <- rep("plot1", 4)

cut <- cutPlot(coord, plot, cornerNum, gridsize = 100, dimX = 200, dimY = 200)

# plot the result
plot(coord, main = "example", xlim = c(4900, 5300), ylim = c(4900, 5300), asp = 1)
text(coord, labels = cornerNum, pos = 1)
points(cut$XAbs, cut$YAbs, pch = "+")
legend("bottomright", legend = c("orignal", "cut"), pch = c("o", "+"))

}
\author{
Arthur PERE
}
