% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaxonomy.R
\name{getTaxonomy}
\alias{getTaxonomy}
\title{Retrieving the taxonomy}
\usage{
getTaxonomy(genus, findOrder = FALSE)
}
\arguments{
\item{genus}{Vector of genus names}

\item{findOrder}{(Boolean) If \code{TRUE}, the output will contain the taxonomical orders of the families.}
}
\value{
Data frame with the order (if \code{findOrder} is \code{TRUE}), family and genus.
}
\description{
From a genus, the function \code{getTaxonomy} finds the APG III family, and optionally the
order, from the \link{genusFamily} database and the \link{apgFamilies} dataset
}
\examples{
# Find the Family of the Aphelandra genus
getTaxonomy("Aphelandra")
# ... and the order
\donttest{
getTaxonomy("Aphelandra", findOrder = TRUE)
}
}
\author{
Ariane TANGUY, Arthur PERE, Maxime REJOU-MECHAIN
}
