% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_sf}
\alias{BIEN_occurrence_sf}
\title{Extract occurrence data for specified sf polygon}
\usage{
BIEN_occurrence_sf(
  sf,
  cultivated = FALSE,
  new.world = NULL,
  all.taxonomy = FALSE,
  native.status = FALSE,
  natives.only = TRUE,
  observation.type = FALSE,
  political.boundaries = FALSE,
  collection.info = FALSE,
  ...
)
}
\arguments{
\item{sf}{An object of class sf. Note that the projection must be WGS84.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records falling within the polygon.
}
\description{
BIEN_occurrence_sf downloads occurrence records falling within a user-specified sf polygon
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php
}
\examples{
\dontrun{
library(sf)  

# first, we download an example shapefile to use (a species range)

BIEN_ranges_species("Carnegiea gigantea")#saves range to the current working directory

# load the range map as an sf object

sf <- st_read(dsn = ".",layer = "Carnegiea_gigantea")

# get the occurrences that occur within the polygon.

species_occurrences <- BIEN_occurrence_sf(sf = sf)
}
}
\seealso{
Other occurrence functions: 
\code{\link{BIEN_occurrence_box}()},
\code{\link{BIEN_occurrence_country}()},
\code{\link{BIEN_occurrence_county}()},
\code{\link{BIEN_occurrence_family}()},
\code{\link{BIEN_occurrence_genus}()},
\code{\link{BIEN_occurrence_records_per_species}()},
\code{\link{BIEN_occurrence_species}()},
\code{\link{BIEN_occurrence_state}()}
}
\concept{occurrence functions}
