% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_box}
\alias{BIEN_occurrence_box}
\title{Extract species occurrence records by a latitude/longitude bounding box.}
\usage{
BIEN_occurrence_box(min.lat, max.lat, min.long, max.long, cultivated = FALSE,
  only.new.world = TRUE, all.taxonomy = FALSE, native.status = FALSE,
  natives.only = TRUE, observation.type = FALSE,
  political.boundaries = TRUE, collection.info = F, ...)
}
\arguments{
\item{min.lat}{Minimum latitude}

\item{max.lat}{Maximum latitude}

\item{min.long}{Minimum longitude}

\item{max.long}{Maximum longitude}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{natives.only}{Exclude detected introduced species?  Default is TRUE.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{collection.info}{Return additional information about collection and identification? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records for the specified area.
}
\description{
BIEN_occurrence_box extracts occurrences records falling within the specific area.
}
\note{
US FIA coordinates have been fuzzed and swapped, for more details see: https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php
}
\examples{
\dontrun{
output_test<-
BIEN_occurrence_box(min.lat = 32,max.lat = 33,min.long = -114,max.long = -113,
cultivated = TRUE, only.new.world = FALSE)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_spatialpolygons}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}
