% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_stem_species}
\alias{BIEN_stem_species}
\title{Extract stem data for specified species from BIEN}
\usage{
BIEN_stem_species(species, cultivated = FALSE, only.new.world = TRUE,
  all.taxonomy = FALSE, native.status = FALSE,
  political.boundaries = FALSE, all.metadata = F, ...)
}
\arguments{
\item{species}{A single species, or a vector of species.  Genus and species should be separated by a space. Genus should be capitalized.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{all.metadata}{Should additional plot metadata be returned?  Default is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing stem data for the specified species.
}
\description{
BIEN_stem_species downloads occurrence records for specific species from the BIEN database.
}
\note{
Setting either "cultivated" or "native.status" to TRUE will significantly slow the speed of a query.
}
\examples{
\dontrun{
BIEN_stem_species("Abies amabilis")
species_vector<-c("Abies amabilis", "Acer nigrum")
BIEN_stem_species(species_vector)
BIEN_stem_species(species_vector,all.taxonomy=TRUE)}
}
\seealso{
Other stem functions: \code{\link{BIEN_stem_datasource}},
  \code{\link{BIEN_stem_family}},
  \code{\link{BIEN_stem_genus}}
}
