% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSex.R
\name{checkSex}
\alias{checkSex}
\title{Validates and Optionally Repairs Sex Coding in a Pedigree Dataframe}
\usage{
checkSex(
  ped,
  code_male = NULL,
  code_female = NULL,
  verbose = FALSE,
  repair = FALSE
)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with a 'sex' column.}

\item{code_male}{The current code used to represent males in the 'sex' column.}

\item{code_female}{The current code used to represent females in the 'sex' column. If both are NULL, no recoding is performed.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{repair}{A logical flag indicating whether to attempt repairs on the sex coding.}
}
\value{
Depending on the value of `repair`, either a list containing validation results or a repaired dataframe is returned.
}
\description{
This function performs two main tasks:
1. Optionally recodes the 'sex' variable based on given codes for males and females.
2. Optionally repairs the sex coding based on specified logic, facilitating the accurate construction of genetic pedigrees.
}
\details{
This function uses the terms 'male' and 'female' in a biological context, based on chromosomes and other biologically-based characteristics relevant to genetic studies.
This usage is not intended to negate the personal gender identity of any individual.

We recognize the importance of using language and methodologies that affirm and respect all gender identities.  While this function focuses on chromosomal information necessary for constructing genetic pedigrees, we affirm that gender is a spectrum, encompassing a wide range of identities beyond the binary.
The developers of this package express unequivocal support for folx in the transgender and LGBTQ+ communities. We respect the complexity of gender identity and acknowledge the distinction between the biological aspect of sex used for genetic analysis (genotype) and the broader, richer concept of gender identity (phenotype).
}
\examples{
\dontrun{
ped <- data.frame(ID = c(1, 2, 3), sex = c("M", "F", "M"))
checkSex(ped, code_male = "M", verbose = TRUE, repair = FALSE)
}
}
