% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.estimate}
\alias{residuals.estimate}
\title{Residuals for \code{estimate} Objects}
\usage{
\method{residuals}{estimate}(object, iter = 500, cred = 0.95, summary = TRUE, ...)
}
\arguments{
\item{object}{object of class \code{estimate}}

\item{iter}{iters used to compute the residuals}

\item{cred}{credible interval used for summarizing}

\item{summary}{summarize the posterior samples (Default is \code{TRUE}).}

\item{...}{currently ignored}
}
\value{
3D array of dimensions n (observations),
        4 (posterior summary),
        p (number of nodes)
}
\description{
Residuals for \code{estimate} Objects
}
\examples{
\donttest{
# data
Y <- subset(tas, gender == "M")[,-ncol(tas)]

# fit model
fit <- estimate(Y)

# diagnostic plot
residuals(fit, iter = 25)
}
}
