% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getG.R
\name{getG_symDMatrix}
\alias{getG_symDMatrix}
\title{Computes a Very Large Genomic Relationship Matrix.}
\usage{
getG_symDMatrix(X, center = TRUE, scale = TRUE, scaleG = TRUE,
  minVar = 1e-05, blockSize = 5000L,
  folderOut = paste0("symDMatrix_", randomString()), vmode = "double",
  i = seq_len(nrow(X)), j = seq_len(ncol(X)), chunkSize = 5000L,
  nCores = getOption("mc.cores", 2L), verbose = FALSE)
}
\arguments{
\item{X}{A matrix-like object, typically \code{@geno} of a \linkS4class{BGData}
object.}

\item{center}{Either a logical value or a numeric vector of length equal to
the number of columns of \code{X}. If \code{FALSE}, no centering is done. Defaults to
\code{TRUE}.}

\item{scale}{Either a logical value or a numeric vector of length equal to
the number of columns of \code{X}. If \code{FALSE}, no scaling is done. Defaults to
\code{TRUE}.}

\item{scaleG}{TRUE/FALSE whether xx' must be scaled.}

\item{minVar}{Columns with variance lower than this value will not be used
in the computation (only if \code{scale} is not \code{FALSE}).}

\item{blockSize}{The number of rows and columns of each block. If \code{NULL}, a
single block of the same length as \code{i} will be created. Defaults to 5000.}

\item{folderOut}{The path to the folder where to save the
\link[symDMatrix:symDMatrix-class]{symDMatrix::symDMatrix} object. Defaults to a random string prefixed
with "symDMatrix_".}

\item{vmode}{vmode of \code{ff} objects.}

\item{i}{Indicates which rows of \code{X} should be used. Can be integer,
boolean, or character. By default, all rows are used.}

\item{j}{Indicates which columns of \code{X} should be used. Can be integer,
boolean, or character. By default, all columns are used.}

\item{chunkSize}{The number of columns of \code{X} that are brought into physical
memory for processing per core. If \code{NULL}, all columns of \code{X} are used.
Defaults to 5000.}

\item{nCores}{The number of cores (passed to \code{\link[parallel:mclapply]{parallel::mclapply()}}).
Defaults to the number of cores as detected by \code{\link[parallel:detectCores]{parallel::detectCores()}}.}

\item{verbose}{Whether progress updates will be posted. Defaults to \code{FALSE}.}
}
\value{
A \link[symDMatrix:symDMatrix-class]{symDMatrix::symDMatrix} object.
}
\description{
Computes a positive semi-definite symmetric genomic relation matrix G=XX'
offering options for centering and scaling the columns of \code{X} beforehand.
}
\details{
Even very large genomic relationship matrices are supported by partitioning
\code{X} into blocks and calling \code{\link[=getG]{getG()}} on these blocks. This function performs
the block computations sequentially, which may be slow. In an HPC
environment, performance can be improved by manually distributing these
operations to different nodes.
}
\section{Multi-level parallelism}{

Functions with the \code{nCores}, \code{i}, and \code{j} parameters provide
capabilities for both parallel and distributed computing.

For parallel computing, \code{nCores} determines the number of cores the code is
run on. Memory usage can be an issue for higher values of \code{nCores} as R is
not particularly memory-efficient. As a rule of thumb, at least around
\code{(nCores * object_size(chunk)) + object_size(result)} MB of total memory
will be needed for operations on file-backed matrices, not including
potential copies of your data that might be created (for example
\code{\link[stats:lsfit]{stats::lsfit()}} runs \code{cbind(1, X)}). \code{i} and \code{j} can be used to include or
exclude certain rows or columns. Internally, the \code{\link[parallel:mclapply]{parallel::mclapply()}}
function is used and therefore parallel computing will not work on Windows
machines.

For distributed computing, \code{i} and \code{j} determine the subset of the input
matrix that the code runs on. In an HPC environment, this can be used not
just to include or exclude certain rows or columns, but also to partition
the task among many nodes rather than cores. Scheduler-specific code and
code to aggregate the results need to be written by the user. It is
recommended to set \code{nCores} to \code{1} as nodes are often cheaper than cores.
}

