% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{crossprod_parallel}
\alias{crossprod_parallel}
\alias{tcrossprod_parallel}
\title{Computes crossprod (x'x or x'y) or tcrossprod (xx' or xy') in Parallel.}
\usage{
crossprod_parallel(x, y = NULL, nTasks = nCores,
  nCores = getOption("mc.cores", 2L))

tcrossprod_parallel(x, y = NULL, nTasks = nCores,
  nCores = getOption("mc.cores", 2L))
}
\arguments{
\item{x}{A matrix-like object, typically \code{@geno} of a \linkS4class{BGData}
object.}

\item{y}{vector or matrix-like object. \code{NULL} by default.}

\item{nTasks}{The number of tasks the problem should be broken into to be
distributed among \code{nCores} cores. Defaults to \code{nCores}.}

\item{nCores}{The number of cores (passed to \code{\link[parallel:mclapply]{parallel::mclapply()}}).
Defaults to the number of cores as detected by \code{\link[parallel:detectCores]{parallel::detectCores()}}.}
}
\value{
x'x or x'y (\code{crossprod_parallel}), or xx' or xy'
(\code{tcrossprod_parallel}), depending on whether \code{y} is provided.
}
\description{
Similar to \code{\link[base:crossprod]{base::crossprod()}} and \code{\link[base:tcrossprod]{base::tcrossprod()}}, but designed to
carry out operations in parallel. The input matrix \code{x} (and \code{y} if not
\code{NULL}) is broken into \code{nTasks} chunks and passed to \code{\link[parallel:mclapply]{parallel::mclapply()}}
which performs \code{\link[base:crossprod]{base::crossprod()}} or \code{\link[base:tcrossprod]{base::tcrossprod()}} on each chunk.
The results are added up and returned.
}
\details{
If \code{nTasks} is \code{1}, \code{\link[base:crossprod]{base::crossprod()}} or \code{\link[base:tcrossprod]{base::tcrossprod()}} will be
called directly without parallelism.
}
\section{Multi-level parallelism}{

Functions with the \code{nCores}, \code{nTasks}, \code{i}, and \code{j} parameters provide
capabilities for both parallel and distributed computing.

For parallel computing, \code{nCores} determines the number of cores the code is
run on, and \code{nTasks} determines into how many tasks the problem is divided
into. \code{nTasks} should be at least as high as \code{nCores} to keep all cores
busy. Memory usage can be an issue for higher values of \code{nCores} and
\code{nTasks} as R is not particularly memory-efficient. As a rule of thumb, at
least around \code{object_size(X) + (nCores * (object_size(X) / nTasks)) + object_size(result)} MB of total memory will be needed for operations on
memory-mapped matrices, not including potential copies of your data that
might be created (for example \code{\link[stats:lsfit]{stats::lsfit()}} runs \code{cbind(1, X)}). \code{i} and
\code{j} can be used to include or exclude certain rows or columns. Internally,
the \code{\link[parallel:mclapply]{parallel::mclapply()}} function is used and therefore parallel computing
will not work on Windows machines.

For distributed computing, \code{i} and \code{j} determine the subset of the input
matrix that the code runs on. In an HPC environment, this can be used not
just to include or exclude certain rows or columns, but also to partition
the task among many nodes rather than cores. Scheduler-specific code and
code to aggregate the results need to be written by the user. It is
recommended to set \code{nCores} and \code{nTasks} to \code{1} as nodes are often cheaper
than cores.
}

\examples{
# Restrict number of cores to 1 on Windows
if (.Platform$OS.type == "windows") {
    options(mc.cores = 1)
}

# Load example data
bg <- BGData:::loadExample()

# Compute xx' in parallel
tcrossprod_parallel(x = bg@geno)

# Compute xy' in parallel (see getG)
tcrossprod_parallel(x = bg@geno, y = bg@geno[1:50, ])

# Compute x'x in parallel
crossprod_parallel(x = bg@geno)
}
\seealso{
\code{\link[=getG]{getG()}} to compute a genomic relationship matrix.
}
