% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneIDsToAllScopes.R
\name{geneIDsToAllScopes}
\alias{geneIDsToAllScopes}
\title{Find all GeneID, ObjectID, TranscriptID, PeptideID and ProbeID corresponding to a Gene in any organism}
\usage{
geneIDsToAllScopes(
  geneids,
  source,
  organism,
  entities = NULL,
  orthologs = TRUE,
  canonical_symbols = TRUE
)
}
\arguments{
\item{geneids}{a character vector of gene identifiers}

\item{source}{the source of gene identifiers. \strong{Guessed if not provided}}

\item{organism}{the gene organism. \strong{Guessed if not provided}}

\item{entities}{a numeric vector of gene entity. If NULL (default),
geneids, source and organism arguments are used to identify genes.
Be carefull when using entities as these identifiers are not stable.}

\item{orthologs}{return identifiers from orthologs}

\item{canonical_symbols}{return only canonical symbols (default: TRUE).}
}
\value{
A data.frame with the following fields:
\itemize{
\item \strong{value}: the identifier
\item \strong{preferred}: preferred identifier for the same BE in the same scope
\item \strong{be}: the type of BE
\item \strong{organism}: the BE organism
\item \strong{source}: the source of the identifier
\item \strong{canonical}: canonical gene product (logical)
\item \strong{symbol}: canonical symbol of the identifier
\item \strong{Gene_entity}: the gene entity input
\item \strong{GeneID} (optional): the gene ID input
\item \strong{Gene_source} (optional): the gene source input
\item \strong{Gene_organism} (optional): the gene organism input
}
}
\description{
Find all GeneID, ObjectID, TranscriptID, PeptideID and ProbeID corresponding to a Gene in any organism
}
