% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_comb_plot.R
\name{gene_comb_plot}
\alias{gene_comb_plot}
\title{Plot of gene/gene ratios of two gene families}
\usage{
gene_comb_plot(data, text, legend_position, a, b)
}
\arguments{
\item{data}{Results from the function gene_comb_funk().}

\item{text}{The legend of the plot.}

\item{legend_position}{The position of the legend. It can be "none","left", "right", "bottom", "top".}

\item{a}{The angle of X-axis legend.}

\item{b}{The distance from X-axis to legend.}
}
\value{
Output is the plot of gene/gene ratios of two gene families.
}
\description{
Gene/gene ratios of two gene families can be plotted as an gene_comb_plot().
}
\examples{
data(IMGTtab1)
gane_comb<-gene_comb_funk(family1 = IMGTtab1$V_GENE_and_allele,
                          family2 = IMGTtab1$J_GENE_and_allele)
gene_comb_plot(gane_comb, "Plot of IGHV and IGHJ ratio", legend_position = "right", a = 35, b = 0.5)
}
\references{
Bischof J. and Ibrahim SM. bcRep: R Package for Comprehensive Analysis of B Cell Receptor Repertoire Data. PLoS One. 11(8):e0161569, 2016. doi: 10.1371/journal.pone.0161569.
}
