% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_bct.R
\name{generate_data}
\alias{generate_data}
\title{Sequence generator}
\usage{
generate_data(ct_theta, N)
}
\arguments{
\item{ct_theta}{a list containing the contexts that specify a model, and also a parameter vector for each context.}

\item{N}{length of the sequence to be generated.}
}
\value{
a simulated sequence as a "character" object
}
\description{
Generates a simulated sequence of data according to a given model and associated parameters. 
An initial context of length equal to the maximum depth of the model is first generated uniformly and independently, and it is deleted after the desired  
number of samples has been generated.
}
\examples{
# Create a list containing contexts and associated parameters.
d1 <- list("0" = c(0.2, 0.8), "10" = c(0.9, 0.1), "11" = c(0,1))

# The contexts need to correspond to the leaves of a proper tree. 
# The key of each vector is the context. 
# For example:
# For context "0": P(x_{i+1} = 0 | x_{i} = 0) = 0.2
# and P(x_{i+1} = 1 | x_{i} = 0) = 0.8

# If a dataset containing only letters is desired:
d2 <- list("ab" = c(0.3, 0.7), "b" = c(0.8, 0.2), "aa" = c(0.5,0.5))

# Generate data from d2
gd <- generate_data(d2, 10000) 

# Use the BCT function to find the MAP model
BCT(gd, 10) # maximum depth of 10

# or the kBCT function can be used:
kBCT(gd, 10, 5) # maximum depth of 10 and top 5 models
}
\seealso{
\code{\link{BCT}}, \code{\link{kBCT}}, \code{\link{MAP_parameters}}
}
