% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_table.R
\name{sim_table}
\alias{sim_table}
\alias{sim_table.bcea}
\title{Table of Simulation Statistics for the Health Economic Model}
\usage{
sim_table(he, ...)

\method{sim_table}{bcea}(he, wtp = 25000, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{...}{Additional arguments}

\item{wtp}{The value of the willingness to pay threshold to be used in the
summary table.}
}
\value{
Produces the following elements:
\item{table}{A table with simulation statistics from the economic model}
\item{names.cols}{A vector of labels to be associated with each column of the table}
\item{wtp}{The selected value of the willingness to pay}
\item{idx_wtp}{The index associated with the selected value of the willingness
to pay threshold in the grid used to run the analysis}
}
\description{
Using the input in the form of MCMC simulations and after having run the
health economic model, produces a summary table of the simulations from the
cost-effectiveness analysis.
}
\examples{
# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

# Load the processed results of the MCMC simulation model
data(Vaccine)

# Runs the health economic evaluation using BCEA
m <- bcea(e=eff,                # defines the variables of 
          c=cost,               # effectiveness and cost
          ref=2,                # selects the 2nd row of (e, c) 
                                # as containing the reference intervention
          interventions=treats, # defines the labels to be associated 
                                # with each intervention
          Kmax=50000)           # maximum value possible for the willingness 
                                # to pay threshold; implies that k is chosen 
                                # in a grid from the interval (0, Kmax)

# Now can save the simulation exercise in an object using sim_table()
sim_table(m,         # uses the results of the economic evaluation 
          wtp=25000) # selects the particular value for k
               
}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}}
}
\author{
Gianluca Baio
}
\keyword{print}
