% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_xxx.R
\name{compute_vi}
\alias{compute_vi}
\title{Compute Value of Information}
\usage{
compute_vi(Ustar, U)
}
\arguments{
\item{Ustar}{Maximum utility value (sim x k)}

\item{U}{Net monetary benefit (sim x k x interv)}
}
\value{
Array with dimensions (sim x k)
}
\description{
The difference between the maximum utility computed for the current
parameter configuration \eqn{U^*} and the utility of the intervention which
is associated with the maximum utility overall.
}
\details{
The value of obtaining additional information on the parameter \eqn{\theta}
to reduce the uncertainty in the decisional process.
It is defined as:

\deqn{\textrm{VI}(\theta) := U^*(\theta) - \mathcal{U}^*}

with \eqn{U^*(\theta)} the maximum utility value for the given simulation
among all comparators and \eqn{\mathcal{U}^*(\theta)} the expected utility
gained by the adoption of the cost-effective intervention.
}
\seealso{
\code{\link{compute_ol}}
}
