% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_four_factors_df.R
\name{do_four_factors_df}
\alias{do_four_factors_df}
\title{Four factors data frame}
\usage{
do_four_factors_df(df_games, teams)
}
\arguments{
\item{df_games}{Data frame with the games, players info, advanced stats and
eventually recoded teams names.}

\item{teams}{Teams names.}
}
\value{
A list with two data frames, \code{df_rank} and \code{df_no_rank}. 
Both have the same columns:
\itemize{
\item Team: Team name.
\item Type: Either Defense or Offense.
\item EFGP, ORBP, TOVP and FTRate.
}

The \code{df_rank} data frame contains the team ranking label for 
each statistic between parentheses. Therefore, \code{df_no_rank} is used
to create the ggplot with the numerical values and \code{df_rank} is
used to add the ranking labels.
}
\description{
This function computes team's offense and defense four factors.
The four factors are Effective Field Goal Percentage (EFGP), 
Turnover Percentage (TOVP), Offensive Rebound Percentage (ORBP) and
Free Throws Rate (FTRate). They are well defined at 
\url{http://www.rawbw.com/~deano/articles/20040601_roboscout.htm} and 
\url{https://www.basketball-reference.com/about/factors.html}.

As a summary, EFGP is a measure of shooting efficiency; TOVP is
the percentage of possessions where the team missed the ball, see
\url{http://www.nba.com/thunder/news/stats101.html} to read about 
the 0.44 coefficient; ORBP measures how many rebounds were offensive 
from the total of available rebounds; Finally, FTRate is a measure of both 
how often a team gets to the line and how often they make them.
}
\details{
Instead of defining the Offensive and Defensive Rebound Percentage
as mentioned in the previous links, I have computed just the Offensive
Rebound Percentage for the team and for its rivals. This makes easier
to have four facets, one per factor, in the ggplot.

In order to establish the team rankings, we have to consider these facts:
In defense (accumulated statistics of the opponent teams to the team of interest), 
the best team in each factor is the one that allows the smallest EFGP, the biggest TOVP, 
the smallest ORBP and the smallest FTRate, respectively.

In offense (accumulated statistics of the team of interest), the best team in each factor 
is the one that has the biggest EFGP, the smallest TOVP, 
the biggest ORBP and the biggest FTRate, respectively.
}
\examples{
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
# When only one team is selected the rankings between parentheses
# do not reflect the real rankings regarding all the league teams.
# The rankings are computed with respect to the number of teams 
# passed as an argument.
df_four_factors <- do_four_factors_df(df1, "Valencia")

}
\seealso{
\code{\link{get_four_factors_plot}}
}
\author{
Guillermo Vinue
}
