% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{tree.quality}
\alias{tree.quality}
\title{Quality of tree.}
\usage{
tree.quality(distance, tree)
}
\arguments{
\item{distance}{A dist matrix representing the initial distances between species.}

\item{tree}{A phylo or hclust object.}
}
\value{
A single value of quality.
}
\description{
Assess the quality of a functional tree.
}
\details{
The algorithm calculates the inverse of mean squared deviation between initial and cophenetic distances (Maire et al. 2015) after standardization of all values between 0 and 1 for simplicity of interpretation. A value of 1 corresponds to maximum quality of the functional representation. A value of 0 corresponds to the expected value for a star tree.
}
\examples{
trait = data.frame(body = c(1,2,3,4,4), beak = c(1,1,1,1,2))
distance = gower(trait)

tree = tree.build(trait)
tree.quality(distance, tree)

distance1 = distance
distance1[] = 1
tree = hclust(distance1)
tree.quality(distance, tree)
}
\references{
Maire et al. (2015) How many dimensions are needed to accurately assess functional diversity? A pragmatic approach for assessing the quality of functional spaces. Global Ecology and Biogeography, 24: 728:740.
}
