% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{optim.alpha.stats}
\alias{optim.alpha.stats}
\title{Efficiency statistics for alpha-sampling.}
\usage{
optim.alpha.stats(comm, tree, methods, samples, runs = 1000)
}
\arguments{
\item{comm}{A samples x species x sites array, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object (used only to optimize PD or FD sampling).}

\item{methods}{A vector specifying the method of each sample (length must be equal to nrow(comm))}

\item{samples}{A vector defining the number of samples per method to be evaluated (length must be equal to number of methods).}

\item{runs}{Number of random permutations to be made to the sample order. Default is 1000.}
}
\value{
A single average alpha diversity value. Rescaled to 0-1 if made for several sites, where 1 is the true diversity of each site.
}
\description{
Average alpha diversity observed with a given number of samples per method.
}
\details{
Different combinations of samples per method allow sampling different sub-communities.
This function allows knowing the average TD, PD or FD values for a given combination, for one or multiple sites simultaneously.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
comm1 <- matrix(c(1,1,0,2,4,0,0,1,2,0,0,3), nrow = 4, ncol = 3, byrow = TRUE)
comm2 <- matrix(c(2,2,0,3,1,0,0,0,5,0,0,2), nrow = 4, ncol = 3, byrow = TRUE)
comm <- array(c(comm1, comm2), c(4,3,2))
colnames(comm) <- c("Sp1","Sp2","Sp3")
methods <- c("Met1","Met2","Met2","Met3")
tree <- hclust(dist(c(1:3), method="euclidean"), method="average")
optim.alpha.stats(comm,,methods, c(1,1,1))
optim.alpha.stats(comm, tree, methods = methods, samples = c(0,0,1), runs = 100)
}
