% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betapriors.R
\name{CCH}
\alias{CCH}
\title{Generalized g-Prior Distribution for Coefficients in BMA Models}
\usage{
CCH(alpha, beta, s = 0)
}
\arguments{
\item{alpha}{a scalar > 0, recommended alpha=.5 (betaprime) or 1 for CCH.
The hyper.g(alpha) is equivalent to CCH(alpha -2, 2, 0). Liang et al
recommended values in the range 2 < alpha_h <= 4}

\item{beta}{a scalar > 0.  The value is not updated by the data; beta should
be a function of n for consistency under the null model.  The hyper-g
corresponds to b = 2}

\item{s}{a scalar, recommended s=0}
}
\value{
returns an object of class "prior", with the family and
hyperparameters.
}
\description{
Creates an object representing the CCH mixture of g-priors on coefficients
for BAS .
}
\details{
Creates a structure used for \code{\link{bas.glm}}.
}
\examples{
CCH(alpha=.5, beta=100, s=0)

}
\seealso{
\code{\link{IC.prior}}, \code{\link{bic.prior}},
\code{\link{bas.glm}}

Other beta priors: \code{\link{EB.local}},
  \code{\link{IC.prior}}, \code{\link{Jeffreys}},
  \code{\link{TG}}, \code{\link{beta.prime}},
  \code{\link{g.prior}}, \code{\link{hyper.g.n}},
  \code{\link{hyper.g}}, \code{\link{intrinsic}},
  \code{\link{robust}}, \code{\link{tCCH}},
  \code{\link{testBF.prior}}
}
\author{
Merlise A Clyde
}
