% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPrior.R
\name{plotPrior}
\alias{plotPrior}
\title{Plot the prior and posterior distribution of shifts}
\usage{
plotPrior(mcmc, expectedNumberOfShifts = 1, burnin = 0.15,
  priorCol = "light blue", postCol = "red", legendPos = "topright", ...)
}
\arguments{
\item{mcmc}{A dataframe of the mcmc_out file from a \code{BAMM} run, or
the filename.}

\item{expectedNumberOfShifts}{Expected number of shifts under the prior.}

\item{burnin}{The fraction of samples to discard as burn-in.}

\item{priorCol}{Color for the prior distribution.}

\item{postCol}{Color for the posterior distribution.}

\item{legendPos}{Placement of the legend, see \code{\link{legend}}.}

\item{\dots}{Additional parameters that are passed to
\code{\link{barplot}}.}
}
\value{
Invisibly returns a matrix with the probability of each shift
    number under the prior and the posterior.
}
\description{
Generates a barplot of the prior and posterior distributions
    of the number of shifts.
}
\examples{
data(mcmc.whales)
plotPrior(mcmc.whales, expectedNumberOfShifts = 1, burnin = 0.15)
}
\author{
Pascal Title
}

