% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/services.R
\name{endpointHelp}
\alias{endpointHelp}
\title{Display AzureML Web Service Endpoint Help Screens.}
\usage{
endpointHelp(ep, type = c("apidocument", "r-snippet", "score", "jobs",
  "update"))
}
\arguments{
\item{ep}{an AzureML web service endpoint from the \code{\link{endpoints}} function.}

\item{type}{the type of help to display.}
}
\value{
Returns the help text. If \code{type = "apidocument"}, then returns the help as a list from a parsed JSON document describing the service.
}
\description{
Download and return help for the specified AzureML web service endpoint.
}
\examples{
\dontrun{
ws <- workspace()

s <- services(ws)
e <- endpoints(ws, s[1,])
endpointHelp(e)

Particularly useful way to see expected service input and output:
endpointHelp(e)$definitions

}
}
\seealso{
Other discovery functions: \code{\link{discoverSchema}},
  \code{\link{endpoints}}, \code{\link{services}},
  \code{\link{workspace}}
}
