% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{save_response_csv}
\alias{save_response_csv}
\title{save_response_csv}
\usage{
save_response_csv(query, filename, expanded = FALSE, with_metadata = TRUE)
}
\arguments{
\item{query}{The query object to be saved}

\item{filename}{(character) Name of the file to be saved.}

\item{expanded}{(logical) Setting this option to TRUE will create a folder
of CSVs representing hierarchical data. See details.}

\item{with_metadata}{Whether to save the metadata of the response as a JSON
file along side the CSV or folder of CSVs.}
}
\value{
Nothing.
}
\description{
Save the records inside the query object as a CSV file, optionally alongside
metadata relating to the requests made to download the data.
}
\details{
Some columns from Arctos are themselves tables, so to accurately represent
the structure of the data, these inner tables can be saved as separate
CSVs that are named according to which record they belong.
}
\examples{
library(ArctosR)

# Request to download all available data
response <- get_records(
  scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
  columns = list("guid", "parts", "partdetail")
)

# Save the response in a flat CSV with an additional metadata file in JSON
save_response_csv(response, "msb-wolves.csv", with_metadata = TRUE)

\dontshow{
unlink("msb-wolves.csv")
unlink("msb-wolves.csv.json")
}

}
