% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhaseStatistics.R
\name{phase_statistics}
\alias{phase_statistics}
\title{Summary statistics of a phase}
\usage{
phase_statistics(min_chain, max_chain, level = 0.95, round_to = 0)
}
\arguments{
\item{min_chain}{Numeric vector containing the output of the MCMC
algorithm for the start of the phase.}

\item{max_chain}{Numeric vector containing the output of the MCMC
algorithm for the end of the phase.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval and the highest density region.}

\item{round_to}{Integer indicating the number of decimal places.}
}
\value{
A list with the following components:
\describe{
\item{statistics}{A data frame where the rows correspond to the
summary statistics and the columns include: \code{start}, the
start of the phase in calendar years (BC/AD); \code{end} the end
of the phase in calendar years (BC/AD); and \code{duration} the
duration of the phase in years.}
\item{level}{Probability corresponding to the level of confidence used
for the credible interval and the highest density region.}
\item{call}{The function call.}
}
}
\description{
Estimation of summary statistics for the beginning, end,
and duration of a phase.
}
\details{
The summary statistics are those given by the \code{MarginalStatistics()} function.
The time range is given by \code{PhaseTimeRange()} function.  The duration is computed
as follows: \eqn{duration = maximum - minimum} at each iteration of the MCMC output.
}
\examples{
  data(Phases); attach(Phases)
  phase_statistics(Phase.1.alpha, Phase.1.beta, 0.95)
  phase_statistics(Phase.2.alpha, Phase.2.beta, 0.95)
  ## round to decade
  phase_statistics(Phase.2.alpha, Phase.2.beta, 0.95, -1)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}
}
