% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OccurrencePlot.R
\name{occurrence_plot}
\alias{occurrence_plot}
\title{Plot occurrences}
\usage{
occurrence_plot(
  data,
  position = 1:ncol(data),
  level = 0.95,
  plot_result = TRUE,
  intervals = "CI",
  title = "Occurrence plot",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  x_label = "Calendar year",
  y_label = NULL,
  language = "English",
  occurrence = "occurrence",
  height = 7,
  width = 7,
  units = "in",
  x_min = NULL,
  x_max = NULL,
  x_scale = "calendar",
  elapsed_origin_position = NULL,
  dumbbell_size = 1,
  dot_guide = FALSE,
  dot_guide_size = 0.25,
  y_grid = FALSE,
  file = NULL,
  new_window = TRUE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the positions of the columns
corresponding to the MCMC chains of interest, or a vector of column
names.}

\item{level}{Probability corresponding to the level of confidence.}

\item{plot_result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}

\item{intervals}{One of "CI" for credible intervals or
"HPD" for highest posterior density intervals.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x_label}{Label of the x-axis.}

\item{y_label}{Label of the y-axis.}

\item{language}{String indicating a language recognized by the
\pkg{toOrdinal} package.}

\item{occurrence}{String to append to each y-axis tic label.}

\item{height}{Plot height in \code{units}.}

\item{width}{Plot width in \code{units}.}

\item{units}{String recognized by the \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{x_min}{Minimum x-axis value.}

\item{x_max}{Maximum x-axis value.}

\item{x_scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for time elapsed from a specified origin.}

\item{elapsed_origin_position}{Position of the column to use
as the origin for elapsed time calculations.}

\item{dumbbell_size}{Size of the plot symbol.}

\item{dot_guide}{Switch for a horizontal guide from the y axis.}

\item{dot_guide_size}{Size of the dot guide.}

\item{y_grid}{Switch for horizontal grid lines.}

\item{file}{Name of the file that will be saved if specified.
If \code{NULL} no plot will be saved.}

\item{new_window}{Whether or not the plot is drawn within a new window.}
}
\value{
An \code{archaeophases_plot} object with the data and metadata
needed to reproduce the plot.
}
\description{
A statistical graphic designed for the archaeological study of when
events of a specified kind occurred
}
\details{
If we have k events, then we can estimate the calendar date t corresponding to the
smallest date such that the number of events observed before t is equal to k.
The \code{OccurrencePlot()} estimates these occurrences and gives the credible
interval or the highest posterior density (HPD) region with a desired level of confidence.
}
\examples{
  data(Events);
  OccurrencePlot(Events[1:1000, ], c(2:5),  print.data.result = FALSE)


\dontrun{
# Read from connection
ox <- read_oxcal("http://tsdye.online/AP/ox.csv")
# Plot all the columns
op <- occurrence_plot(ox, position = 1:ncol(ox))
# Plot again
plot(op)
# View metadata
str(op)
}

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
