% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climateData.R
\docType{data}
\name{climateData}
\alias{climateData}
\title{A dataframe containing raw climate data}
\format{
A data frame containing daily observations of climate parameters:

\verb{    }\emph{\strong{\code{Station_Name:}} name of the weather
station.}

\verb{    }\emph{\strong{\code{Lat:}} latitude of the site in decimal
degrees.}

\verb{    }\emph{\strong{\code{Lon:}} longitude of the site in decimal
degrees.}

\verb{    }\emph{\strong{\code{Elev:}} elevation above sea level in
(meters).}

\verb{    }\emph{\strong{\code{Year:}} year of record "YYYY".}

\verb{    }\emph{\strong{\code{Month:}} month of record "MM".}

\verb{    }\emph{\strong{\code{Day:}} day of record "DD".}

\verb{    }\emph{\strong{\code{Rain:}} daily rainfall in (mm).}

\verb{    }\emph{\strong{\code{Tmax:}} daily maximum temperature at 2-m
height in (°C).}

\verb{    }\emph{\strong{\code{Tmin:}} daily minimum temperature at 2-m
height in (°C).}
}
\source{
INAM - Instituto Nacional de Meteorologia, Mozambique
}
\usage{
data(climateData)
}
\description{
The R data object was obtained from Instituto Nacional de
Meteorologia (INAM). This example data set contains the daily raw climate
data over the period between 1/1/1996 and 12/31/2020 from a weather station
located in Angochen, Nampula province of Mozambique.
}
\examples{
# load example data:
data(climateData)

# Get the structure of the data frame:
str(climateData)

# Get the head of the data frame:
head(climateData)

}
\seealso{
\code{\link{AgroClimateData}, \link{calcEto}}
}
\keyword{datasets}
