% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{initializeCovarianceMatrices}
\alias{initializeCovarianceMatrices}
\title{Initialize Covariance Matrices}
\usage{
initializeCovarianceMatrices(parameter, genome, numMixtures,
  geneAssignment, init.csp.variance = 0.0025)
}
\arguments{
\item{parameter}{A Parameter object that corresponds to one of the model types. 
Valid values are "ROC", "PA", and "FONSE".}

\item{genome}{An object of type Genome necessary for the initialization of the Parameter object.}

\item{numMixtures}{The number of mixture elements for the underlying mixture distribution (numMixtures > 0).}

\item{geneAssignment}{A vector holding the initial mixture assignment for each gene.
The vector length has to equal the number of genes in the genome.
Valid values for the vector range from 1 to numMixtures.
It is possible but not advised to leave a mixture element empty.}

\item{init.csp.variance}{initial proposal variance for codon specific parameter, default is 0.0025.}
}
\value{
parameter Returns the Parameter argument, now modified with initialized mutation, selection, and covariance matrices.
}
\description{
Initialize Covariance Matrices
}
