% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{rasterToAmigaBasicShape}
\alias{rasterToAmigaBasicShape}
\title{Convert a grDevices raster object into an AmigaBasicShape class object.}
\usage{
rasterToAmigaBasicShape(
  x,
  type = c("blitter object", "sprite"),
  palette,
  shadow,
  collision,
  ...
)
}
\arguments{
\item{x}{A \code{\link[grDevices:as.raster]{raster()}} class object to convert into a \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class obejct.}

\item{type}{A \code{character} string indicating what type of graphic needs to be created: "\verb{blitter object}" (default) or "\code{sprite}".}

\item{palette}{A \code{vector} of \code{character} strings, where each element represents a colour. This palette is used to quantize the
colours that occur in the \code{raster} \code{x}.}

\item{shadow}{An optional layer that could be stored with the graphics. This layer could be used for specific
shadow effects when blitting the graphics to the screen. It needs to be a \code{\link[grDevices:as.raster]{raster()}}
object consisting of the colours black (bit unset) and white (bit set). The raster needs to have the same dimensions
as \code{x}. This layer will be omitted when this argument is omitted (or set to \code{NULL}).}

\item{collision}{An optional layer that could be stored with the graphics. This layer could be used for collision
detection between graphical objects. It needs to be a \code{\link[grDevices:as.raster]{raster()}}
object consisting of the colours black (bit unset) and white (bit set). The raster needs to have the same dimensions
as \code{x}. This layer will be omitted when this argument is omitted (or set to \code{NULL}).}

\item{...}{Arguments passed onto \code{\link[=index.colours]{index.colours()}}. Can be used, for instance, to achieve specific dithering effects.}
}
\value{
Returns an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object based on \code{x}.
}
\description{
Convert a \code{\link[grDevices:as.raster]{raster()}} object into an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object.
}
\details{
This method can be used to turn any graphics into an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object. In order to do
so, the colours of the input image (a \code{\link[grDevices:as.raster]{raster()}} object) will be quantized to a
limited palette. This palette can be forced as an argument to this function. Otherwise, it will be based on
the input image.
}
\examples{
\dontrun{
## get a raster image:
ilbm <- as.raster(read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH")))

## convert to an Amiga Basic blitter object:
bob <- rasterToAmigaBasicShape(ilbm, "blitter object")
}
}
\seealso{
Other AmigaBasicShape.operations: 
\code{\link{AmigaBasicShape}},
\code{\link{read.AmigaBasicShape}()},
\code{\link{write.AmigaBasicShape}()}

Other raster.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{as.raster.AmigaBasicShape}()},
\code{\link{bitmapToRaster}()},
\code{\link{dither}()},
\code{\link{index.colours}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rasterToBitmap}()},
\code{\link{rasterToHWSprite}()},
\code{\link{rasterToIFF}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasicShape.operations}
\concept{raster.operations}
