% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{write.AmigaBitmapFont}
\alias{write.AmigaBitmapFont}
\alias{write.AmigaBitmapFontSet}
\title{Write an AmigaBitmapFont(set) file}
\usage{
write.AmigaBitmapFont(x, file, disk = NULL)

write.AmigaBitmapFontSet(x, path = getwd(), disk = NULL)
}
\arguments{
\item{x}{Respectively an \code{\link{AmigaBitmapFont}} or a
\code{\link{AmigaBitmapFontSet}} object depending on which of the
write-functions is called. This is the object that will be written
to the specified file.}

\item{file}{A \code{character} string specifying the file location
to which \code{x} (an \code{\link{AmigaBitmapFont}} object) needs to be written.
It is common practice on the Amiga to use the font height in pixels as
file name.}

\item{disk}{A virtual Commodore Amiga disk to which the \code{file} should be
written. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{path}{A \code{character} string specifying the path where
\code{x} (an \code{\link{AmigaBitmapFontSet}} object) needs to be stored.
The filename for the font set will be extracted from \code{x} using
\code{\link{fontName}} followed by the *.font extension. A subdirectory
will be created with the same name (without the extension) if it doesn't
already exists. In this subdirectory all the nested \code{\link{AmigaBitmapFont}}
objects are stored.}
}
\value{
Invisibly returns the result of the call of \code{close} to the
file connection. Or, when \code{disk} is specified, a copy of
\code{disk} is returned to which the file(s) is/are written.
}
\description{
Functions to write \code{\link{AmigaBitmapFont}} and \code{\link{AmigaBitmapFontSet}}
class objects to files.
}
\details{
\code{\link{AmigaBitmapFontSet}} class objects are written to a *.font
file. The filename used for this purpose is obtained from the object
itself using \code{\link{fontName}}. In addition, a subdirectory is
created automatically (when it doesn't already exist)
to which al the separate bitmap images for each font height are written
to individual files.

\code{\link{AmigaBitmapFont}} class objects can also be written to a
file. In order to use it on a Commodore Amiga or emulator, it is better
to embed the font bitmap in a font set (using \code{\link[AmigaFFH]{c}})
and write the set to corresponding files.
}
\examples{
\dontrun{
## obtain a bitmap font set:
data(font_example)

## write the font set to their files. The file name
## is extracted from the font object, so you only have
## to provide the path:
write.AmigaBitmapFont(font_example, temp.dir())

## extract a font bitmap:
font <- getAmigaBitmapFont(font_example, 9)

## and write it to the temp dir:
write.AmigaBitmapFont(font, file.path(temp.dir(), "9"))

## The following examples require the 'adfExplorer' package:
font.disk <- adfExplorer::blank.amigaDOSDisk("font.disk")
font.disk <- adfExplorer::dir.create.adf(font.disk, "FONTS")
font.disk <- write.AmigaBitmapFontSet(font_example, "DF0:FONTS", font.disk)
}
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{io.operations}
