% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{attrition}
\alias{attrition}
\title{Lose individuals at random}
\usage{
attrition(pop, p)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{p}{the expected proportion of individuals that will
be lost to attrition.}
}
\value{
an object of \code{\link{Pop-class}}
}
\description{
Samples individuals at random to remove from the population. 
The user supplies a probability for the individuals to be 
removed from the population.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=100, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Lose an expected 5\% of individuals
pop = attrition(pop, p=0.05)

}
