% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series.R
\name{ASBT}
\alias{ASBT}
\title{Allelic Series Burden Test}
\usage{
ASBT(
  anno,
  geno,
  pheno,
  apply_int = TRUE,
  covar = NULL,
  indicator = FALSE,
  is_pheno_binary = FALSE,
  method = "none",
  min_mac = 0,
  return_beta = FALSE,
  score_test = FALSE,
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{geno}{(n x snps) genotype matrix.}

\item{pheno}{(n x 1) phenotype vector.}

\item{apply_int}{Apply rank-based inverse normal transform to the phenotype?
Default: TRUE. Ignored if phenotype is binary.}

\item{covar}{(n x p) covariate matrix. Defaults to an (n x 1) intercept.}

\item{indicator}{Convert raw counts to indicators?}

\item{is_pheno_binary}{Is the phenotype binary? Default: FALSE.}

\item{method}{Method for aggregating across categories: ("none", "max",
"sum"). Default: "none".}

\item{min_mac}{Minimum minor allele count for inclusion. Default: 0.}

\item{return_beta}{Return the estimated effect size? Default: FALSE.}

\item{score_test}{Run a score test? If FALSE, performs a Wald test.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}
}
\value{
If \code{return_beta = TRUE}, a list of including the effect size
data.frame "betas" and the p-value "pval". If \code{return_beta = FALSE},
a numeric p-value.
}
\description{
Burden test with allelic series weights.
}
\examples{
# Generate data.
data <- DGP(n = 1e3, snps = 1e2)

# Run the Allelic Series Burden Test.
# Note: the output is a scalar p-value.
results <- ASBT(
  anno = data$anno,
  geno = data$geno,
  pheno = data$pheno,
  covar = data$covar
)
}
