% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_arrange.R
\name{plot_arrange}
\alias{plot_arrange}
\title{Merge multiple curves into a single graph}
\usage{
plot_arrange(
  plots,
  point = "mean",
  theme = theme_classic(),
  legend.title = NULL,
  legend.position = "top",
  trat = NA,
  gray = FALSE,
  ylab = "Dependent",
  xlab = "Independent",
  widthbar = 0,
  pointsize = 4.5,
  linesize = 0.8,
  textsize = 12,
  legendsize = 12,
  legendtitlesize = 12,
  fontfamily = "sans"
)
}
\arguments{
\item{plots}{list with objects of type analysis.}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.title}{caption title}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{trat}{name of the curves}

\item{gray}{gray scale (\emph{default} is FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{widthbar}{bar width (\emph{default} is 0.3)}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{textsize}{Font size}

\item{legendsize}{Legend size text}

\item{legendtitlesize}{Title legend size}

\item{fontfamily}{font family}
}
\value{
The function returns a graph joining the outputs of the functions LM_model, LL_model, BC_model, CD_model, loess_model, normal_model, piecewise_model and N_model
}
\description{
Merge multiple curves into a single graph
}
\examples{
library(AgroReg)
library(ggplot2)
data("aristolochia")
attach(aristolochia)
a=LM(trat,resp)
b=LL(trat,resp,npar = "LL.3")
plot_arrange(list(a,b))

models <- c("LM1", "LL3")
r <- lapply(models, function(x) {
r <- with(granada, regression(time, WL, model = x))
})
plot_arrange(r,trat=models,ylab="WL (\%)",xlab="Time (Minutes)")

models = c("asymptotic_neg", "biexponential", "LL4", "BC4", "CD5", "linear.linear",
           "linear.plateau", "quadratic.plateau", "mitscherlich", "MM2")
m = lapply(models, function(x) {
           m = with(granada, regression(time, WL, model = x))})
           plot_arrange(m, trat = paste("(",models,")"))
}
\author{
Gabriel Danilo Shimizu
}
