% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_function.R
\name{time_to_initiation}
\alias{time_to_initiation}
\title{Computation of initiation times.}
\usage{
time_to_initiation(presc.data = NULL, disp.data = NULL,
  ID.colname = NA, presc.start.colname = NA, disp.date.colname = NA,
  medication.class.colnames = NA, date.format = "\%d.\%m.\%Y",
  suppress.warnings = FALSE, return.data.table = FALSE, ...)
}
\arguments{
\item{presc.data}{A \emph{\code{data.frame}} or \emph{\code{data.table}} containing
the prescription events. Must contain, at a minimum, the patient unique ID,
one medication identifier, and the start date of the prescription, and might
also contain additional columns to identify and group medications (the actual
column names are defined in the \emph{\code{medication.class.colnames}} parameter).}

\item{disp.data}{A \emph{\code{data.frame}} or \emph{\code{data.table}} containing
the dispensing events. Must contain, at a minimum, the patient unique ID, one
medication identifier, the dispensing date, and might also contain additional
columns to identify and group medications (the actual column names are defined
in the \emph{\code{medication.class.colnames}} parameter).}

\item{ID.colname}{A \emph{string}, the name of the column in \code{presc.data}
and \code{disp.data} containing the unique patient ID, or \code{NA} if not defined.}

\item{presc.start.colname}{A \emph{string}, the name of the column in
\code{presc.data} containing the prescription date (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{disp.date.colname}{A \emph{string}, the name of the column in
\code{disp.data} containing the dispensing date (in the format given in
the \code{date.format} parameter), or \code{NA} if not defined.}

\item{medication.class.colnames}{A \emph{\code{Vector}} of \emph{strings}, the
name(s) of the column(s) in \code{data} containing the classes/types/groups of
medication, or \code{NA} if not defined.}

\item{date.format}{A \emph{string} giving the format of the dates used in
the \code{data} and the other parameters; see the \code{format} parameters
of the \code{\link[base]{as.Date}} function for details (NB, this concerns
only the dates given as strings and not as \code{Date} objects).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{return.data.table}{\emph{Logical}, if \code{TRUE} return a
\code{data.table} object, otherwise a \code{data.frame}.}

\item{...}{other possible parameters}
}
\value{
A \code{data.frame} or \code{data.table} with the following columns:
\itemize{
 \item \code{ID.colname} the unique patient ID, as given by the \code{ID.colname}
 parameter.
 \item \code{medication.class.colnames} the column(s) with classes/types/groups
 of medication, as given by the  \code{medication.class.colnames} parameter.
 \item \code{first.presc} the date of the first prescription event.
 \item \code{first.disp} the date of the first dispensing event.
 \item \code{time.to.initialization} the difference in days between the first
 dispensing date and the  first prescription date.
 }
 @examples
 time_init <- time_to_initiation(presc.data = durcomp.prescribing,
                                 disp.data = durcomp.dispensing,
                                 ID.colname = "ID",
                                 presc.start.colname = "DATE.PRESC",
                                 disp.date.colname = "DATE.DISP",
                                 medication.class.colnames = c("ATC.CODE", "FORM", "UNIT"),
                                 date.format = "%Y-%m-%d",
                                 suppress.warnings = FALSE,
                                 return.data.table = TRUE)
 @export
}
\description{
Computes the time between the first prescription event and the first dispensing
event for each medication class.
}
\details{
The period between the first prescription event and the first dose administration
may impact health outcomes differently than omitting doses once on treatment or
interrupting medication for longer periods of time. Primary non-adherence (not
acquiring the first prescription) or delayed initiation may have a negative
impact on health outcomes. The function \code{time_to_initiation} calculates
the time between the first prescription and the first dispensing event, taking
into account multiple variables to differentiate between treatments.
}
