% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimalNoBins.R
\name{OptimalNoBins}
\alias{OptimalNoBins}
\title{Optimal Number Of Bins}
\usage{
OptimalNoBins(Data)
}
\arguments{
\item{Data}{Data}
}
\value{
optNrOfBins The best possible number of bins. Not less than 10 though
}
\description{
Calculation of the optimal number of bins for a histogram.
}
\details{
The bin width ist defined with bw=3.49*stdrobust(1/(n)^1/3)
}
\note{
OptimalNoBins() is a kernel density estimation for fixed intervals.
}
\examples{

Data = c(rnorm(1000),rnorm(2000)+2,rnorm(1000)*2-1)

optNrOfBins = OptimalNoBins(Data)

minData = min(Data,na.rm = TRUE)

maxData = max(Data,na.rm = TRUE)

i = maxData-minData

optBreaks = seq(minData, maxData, i/optNrOfBins) # bins in fixed intervals 

hist(Data, breaks=optBreaks)

}
\references{
David W. Scott Jerome P. Keating: A Primer on Density Estimation for the Great Home Run Race of 98, STATS 25, 1999, pp 16-22.

\strong{See Also}

ParetoRadius
}
\author{
Alfred Ultsch, Michael Thrun
}
