% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_plot_desc.R
\name{step1_plot_desc}
\alias{step1_plot_desc}
\title{Plot Stability Data}
\usage{
step1_plot_desc(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  validation = NULL,
  xname = NULL,
  yname = NULL,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data.}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data}

\item{.time}{Time variable contained within data.}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{validation}{Validation dummy variable (column name) (optional).}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{xlim}{x-axis limits (optional).}

\item{ylim}{y-axis limits (optional).}
}
\value{
Plot of raw accelerated stability data.
}
\description{
Plot raw accelerated stability data.
}
\details{
Plot the raw accelerated stability data by selecting the columns -
response, time and temperature.
}
\examples{
#load example datasets
data(antigenicity)
data(potency)

step1_plot_desc(data=antigenicity, y="conc", .time="time", C = "Celsius")

step1_plot_desc(data=potency, y="Potency", .time="Time", C = "Celsius")

}
