/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.metrics.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public abstract class InterceptingMetricsFactory
implements IMetricsFactory {
    private final IMetricsFactory other;

    public InterceptingMetricsFactory(IMetricsFactory other) {
        this.other = other;
    }

    @Override
    public IMetricsScope createMetrics() {
        IMetricsScope otherScope = this.other.createMetrics();
        this.interceptCreateMetrics(otherScope);
        return new InterceptingMetricsScope(otherScope);
    }

    protected void interceptCreateMetrics(IMetricsScope scope) {
    }

    protected void interceptAddData(String name, double value, StandardUnit unit, IMetricsScope scope) {
        scope.addData(name, value, unit);
    }

    protected void interceptAddData(String name, double value, StandardUnit unit, MetricsLevel level, IMetricsScope scope) {
        scope.addData(name, value, unit, level);
    }

    protected void interceptAddDimension(String name, String value, IMetricsScope scope) {
        scope.addDimension(name, value);
    }

    protected void interceptEnd(IMetricsScope scope) {
        scope.end();
    }

    private class InterceptingMetricsScope
    implements IMetricsScope {
        private IMetricsScope other;

        public InterceptingMetricsScope(IMetricsScope other) {
            this.other = other;
        }

        @Override
        public void addData(String name, double value, StandardUnit unit) {
            InterceptingMetricsFactory.this.interceptAddData(name, value, unit, this.other);
        }

        @Override
        public void addData(String name, double value, StandardUnit unit, MetricsLevel level) {
            InterceptingMetricsFactory.this.interceptAddData(name, value, unit, level, this.other);
        }

        @Override
        public void addDimension(String name, String value) {
            InterceptingMetricsFactory.this.interceptAddDimension(name, value, this.other);
        }

        @Override
        public void end() {
            InterceptingMetricsFactory.this.interceptEnd(this.other);
        }
    }
}

